/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import noppes.npcs.client.gui.util.GuiButtonBiDirectional;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.entity.data.DataMelee;

public class SubGuiNpcMeleeProperties
extends SubGuiInterface
implements ITextfieldListener {
    private static final String[] potionNames = new String[]{"gui.none", "tile.fire.name", "effect.poison", "effect.hunger", "effect.weakness", "effect.moveSlowdown", "effect.confusion", "effect.blindness", "effect.wither"};
    private final DataMelee stats;

    public SubGuiNpcMeleeProperties(DataMelee data) {
        this.setBackground("menubg.png");
        this.xSize = 256;
        this.ySize = 216;
        this.closeOnEsc = true;
        this.stats = data;
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 5: {
                this.stats.setEffect(button.getValue(), this.stats.getEffectStrength(), this.stats.getEffectTime());
                this.func_73866_w_();
                break;
            }
            case 7: {
                this.stats.setEffect(this.stats.getEffectType(), button.getValue(), this.stats.getEffectTime());
                break;
            }
            case 66: {
                this.close();
            }
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addLabel(new GuiNpcLabel(1, "stats.meleestrength", this.guiLeft + 5, this.guiTop + 15));
        GuiNpcTextField textField = new GuiNpcTextField(1, this, this.field_146289_q, this.guiLeft + 85, this.guiTop + 10, 50, 18, this.stats.getStrength() + "");
        textField.setMinMaxDefault(0L, Integer.MAX_VALUE, 5L);
        textField.setHoverText("stats.hover.attack.strength", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(2, "stats.meleerange", this.guiLeft + 5, this.guiTop + 45));
        textField = new GuiNpcTextField(2, this, this.field_146289_q, this.guiLeft + 85, this.guiTop + 40, 50, 18, (float)Math.round(this.stats.getRange() * 10.0) / 10.0f + "");
        textField.setMinMaxDoubleDefault(0.2, 30.0, 2.0);
        textField.setHoverText("stats.hover.attack.range", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(3, "stats.meleespeed", this.guiLeft + 5, this.guiTop + 75));
        textField = new GuiNpcTextField(3, this, this.field_146289_q, this.guiLeft + 85, this.guiTop + 70, 50, 18, this.stats.getDelay() + "");
        textField.setMinMaxDefault(1L, 1000L, 20L);
        textField.setHoverText("stats.hover.attack.speed", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(4, "enchantment.knockback", this.guiLeft + 5, this.guiTop + 105));
        textField = new GuiNpcTextField(4, this, this.field_146289_q, this.guiLeft + 85, this.guiTop + 100, 50, 18, this.stats.getKnockback() + "");
        textField.setMinMaxDefault(0L, 4L, 0L);
        textField.setHoverText("stats.hover.attack.knockback", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(5, "stats.meleeeffect", this.guiLeft + 5, this.guiTop + 135));
        GuiNpcButton button = new GuiButtonBiDirectional(5, this.guiLeft + 85, this.guiTop + 130, 100, 20, potionNames, this.stats.getEffectType());
        button.setHoverText("stats.hover.attack.effects", new Object[0]);
        this.addButton(button);
        if (this.stats.getEffectType() != 0) {
            this.addLabel(new GuiNpcLabel(6, "gui.time", this.guiLeft + 5, this.guiTop + 165));
            textField = new GuiNpcTextField(6, this, this.field_146289_q, this.guiLeft + 85, this.guiTop + 160, 50, 18, this.stats.getEffectTime() + "");
            textField.setMinMaxDefault(1L, 99999L, 5L);
            textField.setHoverText("stats.hover.attack.effect", new Object[0]);
            this.addTextField(textField);
            if (this.stats.getEffectType() != 1) {
                this.addLabel(new GuiNpcLabel(7, "stats.amplify", this.guiLeft + 5, this.guiTop + 195));
                button = new GuiButtonBiDirectional(7, this.guiLeft + 85, this.guiTop + 190, 52, 20, new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"}, this.stats.getEffectStrength());
                button.setHoverText("stats.hover.effect.power", new Object[0]);
                this.addButton(button);
            }
        }
        button = new GuiNpcButton(66, this.guiLeft + 164, this.guiTop + 192, 90, 20, "gui.done");
        button.setHoverText("hover.back", new Object[0]);
        this.addButton(button);
    }

    @Override
    public void unFocused(IGuiNpcTextField textfield) {
        switch (textfield.getID()) {
            case 1: {
                this.stats.setStrength(textfield.getInteger());
                break;
            }
            case 2: {
                this.stats.setRange(textfield.getDouble());
                break;
            }
            case 3: {
                this.stats.setDelay(textfield.getInteger());
                break;
            }
            case 4: {
                this.stats.setKnockback(textfield.getInteger());
                break;
            }
            case 6: {
                this.stats.setEffect(this.stats.getEffectType(), this.stats.getEffectStrength(), textfield.getInteger());
            }
        }
    }
}

